# Train_from_Scratch

This directory provides scripts and modules for training transformer models from scratch, including FAL and FAL+ variants.

- **GPT2.py**: Baseline GPT-2 implementation.
- **Train_Scratch_FAL/**: Training scripts and model code for FAL.
- **Train_Scratch_FALp/**: Training scripts and model code for FAL+.

## File Descriptions

| Folder/File                          | Description                                                                                     |
|--------------------------------------|-------------------------------------------------------------------------------------------------|
| `GPT2.py`                            | Baseline GPT-2 implementation.                                                                 |
| `Train_Scratch_FAL/Train_Scratch.py` | Training script for FAL family models.                                                          |
| `Train_Scratch_FAL/FAL_forwards.py`  | Implements forward pass logic for FAL models.                                                  |
| `Train_Scratch_FAL/FAL_policy.py`    | Defines distributed execution policies for FAL models.                                         |
| `Train_Scratch_FAL/modeling_FAL_Replace.py` | Model architecture and utilities for FAL family training.                                       |
| `Train_Scratch_FALp/Train_Scratch.py`| Training script for FAL+ models.                                                               |
| `Train_Scratch_FALp/custom_gpt2.py`  | Custom GPT-2 implementation for FAL+ models.                                                   |
| `Train_Scratch_FALp/falp_policy.py`  | Defines distributed execution policies for FAL+ models.                                        |
| `Train_Scratch_FALp/modeling_falp.py`| Model architecture and utilities for FAL+ training.                                            |

## How to Run

Below are examples of how to run the training scripts for FAL and FAL+ models:

### FAL Training
To train a model using FAL:
```bash
colossalai run --nproc_per_node ? Train_Scratch_FAL/Train_Scratch.py
```